<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\Factories\HasFactory;

class Menu extends Model
{
    use HasFactory;

    protected $fillable = [
        'name', 'icon', 'description', 'status'
    ];

    public function contents()
    {
        return $this->hasMany(Content::class);
    }

    public function content()
    {
        return $this->hasOne(Content::class, 'menu_id');
    }
}
