<?php

namespace Database\Seeders;

use Illuminate\Database\Seeder;
use App\Models\Contoh;
use App\Models\Content;

class ContohSeeder extends Seeder
{
    public function run(): void
    {
        // Hapus semua contoh lama
        Contoh::truncate();

        $contents = Content::all();
        foreach ($contents as $content) {
            for ($i = 1; $i <= 3; $i++) {
                Contoh::create([
                    'content_id' => $content->id,
                    'nama' => 'Contoh ' . $i . ' untuk ' . $content->title,
                    'fokus_utama' => 'Fokus utama ' . $i,
                    'aspek_unik' => 'Aspek unik ' . $i,
                    'isi' => '<p>Isi contoh ke-' . $i . ' untuk ' . $content->title . '</p>',
                ]);
            }
        }
    }
} 