@extends('layouts.dashboard')

@section('content')
<div class="container-fluid px-2 px-md-4 py-4">
    <div class="row justify-content-center">
        <div class="col-12">
            <div class="card shadow-sm" style="border-radius: 1rem;">
                <div class="card-header d-flex justify-content-between align-items-center">
                    <h4 class="mb-0">Daftar Konten</h4>
                    <a href="{{ route('content.create') }}" class="btn btn-primary">+ Tambah Konten</a>
                </div>
                <div class="card-body">
                    @if(session('success'))
                        <div class="alert alert-success">{{ session('success') }}</div>
                    @endif
                    <div class="table-responsive">
                        <table class="table table-bordered table-hover align-middle">
                            <thead class="table-light">
                                <tr>
                                    <th style="width: 5%">No</th>
                                    <th>Judul</th>
                                    <th>Menu</th>
                                    <th>Kategori</th>
                                    <th>Status</th>
                                    <th>Penulis</th>
                                    <th>Tanggal Dibuat</th>
                                    <th style="width: 15%">Aksi</th>
                                </tr>
                            </thead>
                            <tbody>
                                @forelse($contents as $index => $content)
                                    <tr>
                                        <td>{{ $index + 1 }}</td>
                                        <td>{{ $content->title }}</td>
                                        <td>{{ $content->menu->name ?? '-' }}</td>
                                        <td>{{ $content->category->name ?? '-' }}</td>
                                        <td>
                                            <span class="badge bg-{{ $content->status == 'published' ? 'success' : 'warning' }}">
                                                {{ ucfirst($content->status) }}
                                            </span>
                                        </td>
                                        <td>{{ $content->user->name ?? '-' }}</td>
                                        <td>{{ $content->created_at ? $content->created_at->format('d M Y H:i') : '-' }}</td>
                                        <td>
                                            <a href="{{ route('content.show', $content->id) }}" class="btn btn-info btn-sm" title="Lihat"><i class="fas fa-eye"></i></a>
                                            <a href="{{ route('content.edit', $content->id) }}" class="btn btn-warning btn-sm" title="Edit"><i class="fas fa-edit"></i></a>
                                            <form action="{{ route('content.destroy', $content->id) }}" method="POST" style="display:inline;">
                                                @csrf
                                                @method('DELETE')
                                                <button type="submit" class="btn btn-danger btn-sm" onclick="return confirm('Yakin ingin menghapus konten ini?')" title="Hapus"><i class="fas fa-trash"></i></button>
                                            </form>
                                        </td>
                                    </tr>
                                @empty
                                    <tr>
                                        <td colspan="8" class="text-center text-muted">Belum ada data konten.</td>
                                    </tr>
                                @endforelse
                            </tbody>
                        </table>
                    </div>
                    <div class="d-flex justify-content-center mt-3">
                        {{-- Pagination dihapus karena semua data tampil --}}
                    </div>
                </div>
            </div>
        </div>
    </div>
</div>
@endsection
