@extends('layouts.app')

@section('title', 'Konten - ' . $menu->name)

@section('content')
<div class="container mx-auto px-4 py-8">
    <div class="mb-6">
        <h1 class="text-3xl font-bold text-gray-900 mb-2">{{ $menu->name }}</h1>
        @if($menu->description)
            <p class="text-gray-600">{{ $menu->description }}</p>
        @endif
    </div>

    @if($contents->count() > 0)
        <div class="grid grid-cols-1 md:grid-cols-2 lg:grid-cols-3 gap-6">
            @foreach($contents as $content)
                <div class="bg-white rounded-lg shadow-md overflow-hidden">
                    @if($content->image)
                        <img src="{{ asset('storage/' . $content->image) }}" 
                             alt="{{ $content->title }}" 
                             class="w-full h-48 object-cover">
                    @endif
                    <div class="p-6">
                        <h3 class="text-xl font-semibold text-gray-900 mb-2">
                            <a href="{{ route('content.show', $content) }}" 
                               class="hover:text-blue-600 transition-colors">
                                {{ $content->title }}
                            </a>
                        </h3>
                        <p class="text-gray-600 mb-4 line-clamp-3">
                            {{ Str::limit($content->description, 150) }}
                        </p>
                        <div class="flex items-center justify-between text-sm text-gray-500">
                            <div class="flex items-center space-x-2">
                                <span class="px-2 py-1 rounded-full text-xs 
                                    {{ $content->status === 'published' ? 'bg-green-100 text-green-800' : 'bg-yellow-100 text-yellow-800' }}">
                                    {{ ucfirst($content->status) }}
                                </span>
                                @if($content->category)
                                    <span class="px-2 py-1 rounded-full text-xs bg-blue-100 text-blue-800">
                                        {{ $content->category->name }}
                                    </span>
                                @endif
                            </div>
                            <span>{{ $content->created_at->format('d M Y') }}</span>
                        </div>
                    </div>
                </div>
            @endforeach
        </div>

        <div class="mt-8">
            {{ $contents->links() }}
        </div>
    @else
        <div class="text-center py-12">
            <div class="text-gray-400 mb-4">
                <svg class="mx-auto h-12 w-12" fill="none" viewBox="0 0 24 24" stroke="currentColor">
                    <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M9 12h6m-6 4h6m2 5H7a2 2 0 01-2-2V5a2 2 0 012-2h5.586a1 1 0 01.707.293l5.414 5.414a1 1 0 01.293.707V19a2 2 0 01-2 2z" />
                </svg>
            </div>
            <h3 class="text-lg font-medium text-gray-900 mb-2">Belum ada konten</h3>
            <p class="text-gray-500">Belum ada konten yang dipublikasikan untuk menu ini.</p>
        </div>
    @endif

    <div class="mt-8">
        <a href="{{ route('menus.index') }}" 
           class="inline-flex items-center px-4 py-2 bg-gray-600 text-white rounded-md hover:bg-gray-700 transition-colors">
            <svg class="w-4 h-4 mr-2" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M10 19l-7-7m0 0l7-7m-7 7h18" />
            </svg>
            Kembali ke Menu
        </a>
    </div>
</div>
@endsection 