@extends('layouts.dashboard')
@section('content')
<div class="container">
    <h2>Daftar Menu</h2>
    <a href="{{ route('menus.create') }}" class="btn btn-primary mb-3">Tambah Menu</a>
    @if(session('success'))
        <div class="alert alert-success">{{ session('success') }}</div>
    @endif
    <table class="table table-bordered">
        <thead>
            <tr>
                <th>#</th>
                <th>Nama</th>
                <th>Icon</th>
                <th>Deskripsi</th>
                <th>Urutan</th>
                <th>Status</th>
                <th>Aksi</th>
            </tr>
        </thead>
        <tbody>
            @foreach($menus as $menu)
            <tr>
                <td>{{ $loop->iteration }}</td>
                <td>{{ $menu->name }}</td>
                <td><span class="material-icons">{{ $menu->icon }}</span></td>
                <td>{{ $menu->description }}</td>
                <td>{{ $menu->order }}</td>
                <td>{{ $menu->status ? 'Aktif' : 'Nonaktif' }}</td>
                <td>
                    <div style="display: flex; gap: 4px; align-items: center;">
                        <a href="{{ route('menu.contents', $menu) }}" class="btn btn-sm btn-success" title="Lihat Konten" style="padding: 4px 7px;"><i class="fas fa-list"></i></a>
                        <a href="{{ route('menus.show', $menu) }}" class="btn btn-sm btn-info" title="Lihat" style="padding: 4px 7px;"><i class="fas fa-eye"></i></a>
                        <a href="{{ route('menus.edit', $menu) }}" class="btn btn-sm btn-warning" title="Edit" style="padding: 4px 7px;"><i class="fas fa-pen"></i></a>
                        <form action="{{ route('menus.destroy', $menu) }}" method="POST" style="display:inline; margin:0;">
                            @csrf @method('DELETE')
                            <button type="submit" class="btn btn-sm btn-danger" title="Hapus" style="padding: 4px 7px;" onclick="return confirm('Yakin hapus?')"><i class="fas fa-trash"></i></button>
                        </form>
                    </div>
                </td>
            </tr>
            @endforeach
        </tbody>
    </table>
</div>
@endsection 