@php $isAjax = request()->ajax(); @endphp
<div class="container">
    <div class="row justify-content-center">
        <div class="col-md-10">
            <div class="card">
                <div class="card-header d-flex justify-content-between align-items-center">
                    <h5 class="mb-0">
                        <i class="fas fa-lightbulb me-2"></i>
                        Edit Refleksi Dari Hasil Pendalaman Materi yang telah Anda pelajari
                    </h5>
                    @if(isset($content_id) && $content_id)

                    @endif
                </div>
                <div class="card-body">
                    @if ($errors->any())
                        <div class="alert alert-danger">
                            <ul class="mb-0">
                                @foreach ($errors->all() as $error)
                                    <li>{{ $error }}</li>
                                @endforeach
                            </ul>
                        </div>
                    @endif

                    <form action="{{ route('refleksi.update', $refleksi->id) }}" method="POST" id="formEditRefleksi">
                        @csrf
                        @method('PUT')
                        <input type="hidden" name="content_id" value="{{ isset($content_id) ? $content_id : (isset($content) ? $content->id : '') }}">
                        <input type="hidden" name="redirect_to" value="{{ url()->previous() }}">
                        <!-- Refleksi Content with Summernote -->
                        <div class="mb-4">
                            <label for="refleksi" class="form-label">
                                <i class="fas fa-edit me-1"></i>
                                Isi Refleksi <span class="text-danger">*</span>
                            </label>
                            <textarea class="form-control @error('refleksi') is-invalid @enderror" 
                                name="refleksi" 
                                id="refleksi" 
                                rows="10" 
                                placeholder="Tulis refleksi Anda di sini...">{{ old('refleksi', isset($refleksi) ? $refleksi->refleksi : '') }}</textarea>
                            @error('refleksi')
                                <div class="invalid-feedback">
                                    {{ $message }}
                                </div>
                            @enderror
                            <div class="form-text">
                                <i class="fas fa-lightbulb me-1"></i>
                                Refleksi adalah proses berpikir mendalam tentang pengalaman belajar Anda. 
                            </div>
                        </div>
                        <!-- Action Buttons -->
                        <div class="d-flex justify-content-between">
                            <button type="button" class="btn btn-secondary" onclick="history.back()">
                                <i class="fas fa-times me-1"></i>
                                Batal
                            </button>
                            <div>
                                <button type="reset" class="btn btn-warning me-2">
                                    <i class="fas fa-undo me-1"></i>
                                    Reset
                                </button>
                                <button type="submit" class="btn btn-primary">
                                    <i class="fas fa-save me-1"></i>
                                    Simpan Refleksi
                                </button>
                            </div>
                        </div>
                    </form>
                </div>
            </div>
        </div>
    </div>
</div>
<!-- Hapus Summernote, ganti dengan QuillJS -->
<!-- Custom Styles -->
<style>
    .card {
        border: none;
        border-radius: 0.5rem;
        box-shadow: 0 0.125rem 0.25rem rgba(0, 0, 0, 0.075);
    }
    .card-header {
        background: linear-gradient(135deg, #667eea 0%, #764ba2 100%);
        color: white;
        border-radius: 0.5rem 0.5rem 0 0 !important;
    }
    .form-label {
        font-weight: 600;
        color: #495057;
    }
    .form-control:focus {
        border-color: #667eea;
        box-shadow: 0 0 0 0.2rem rgba(102, 126, 234, 0.25);
    }
    .btn-primary {
        background: linear-gradient(135deg, #667eea 0%, #764ba2 100%);
        border: none;
        border-radius: 0.375rem;
        padding: 0.5rem 1.5rem;
        font-weight: 600;
        transition: all 0.3s ease;
    }
    .btn-primary:hover {
        transform: translateY(-1px);
        box-shadow: 0 4px 8px rgba(102, 126, 234, 0.3);
    }
    .btn-secondary {
        background: #6c757d;
        border: none;
        border-radius: 0.375rem;
        padding: 0.5rem 1.5rem;
        font-weight: 600;
        transition: all 0.3s ease;
    }
    .btn-warning {
        background: #ffc107;
        border: none;
        border-radius: 0.375rem;
        padding: 0.5rem 1.5rem;
        font-weight: 600;
        transition: all 0.3s ease;
        color: #212529;
    }
    .btn:hover {
        transform: translateY(-1px);
    }
    .form-text {
        color: #6c757d;
        font-size: 0.875rem;
    }
    .text-danger {
        color: #dc3545 !important;
    }
    .invalid-feedback {
        display: block;
        color: #dc3545;
        font-size: 0.875rem;
        margin-top: 0.25rem;
    }
    .is-invalid {
        border-color: #dc3545;
    }
    .is-invalid:focus {
        border-color: #dc3545;
        box-shadow: 0 0 0 0.2rem rgba(220, 53, 69, 0.25);
    }
    /* TinyMCE Customization */
    .tox-tinymce {
        border-radius: 0.375rem;
        border: 1px solid #ced4da;
    }
    .tox-tinymce:focus-within {
        border-color: #667eea;
        box-shadow: 0 0 0 0.2rem rgba(102, 126, 234, 0.25);
    }
    /* Responsive Styles for Mobile */
    @media (max-width: 768px) {
        .container {
            padding-left: 0.5rem;
            padding-right: 0.5rem;
        }
        .card {
            border-radius: 0.25rem;
            box-shadow: 0 0.05rem 0.1rem rgba(0,0,0,0.05);
        }
        .card-header {
            font-size: 1rem;
            padding: 0.75rem 1rem;
        }
        .form-label {
            font-size: 1rem;
        }
        .form-control, .tox-tinymce {
            font-size: 1rem;
        }
        .btn {
            width: 100%;
            margin-bottom: 0.5rem;
        }
        .d-flex.justify-content-between {
            flex-direction: column;
            gap: 0.5rem;
        }
        .d-flex.justify-content-between > * {
            width: 100%;
        }
        .btn-primary, .btn-secondary, .btn-warning {
            padding: 0.75rem 1rem;
            font-size: 1rem;
        }
        .mb-4 {
            margin-bottom: 1rem !important;
        }
    }
    @media (max-width: 576px) {
        .card-header h5 {
            font-size: 1rem;
        }
        .form-label {
            font-size: 0.95rem;
        }
        .form-control, .tox-tinymce {
            font-size: 0.95rem;
        }
        .btn-primary, .btn-secondary, .btn-warning {
            font-size: 0.95rem;
        }
    }
</style>
<script src="https://cdn.jsdelivr.net/npm/tinymce@6.8.3/tinymce.min.js"></script>
<script>
  tinymce.init({
    selector: '#refleksi',
    height: 600,
    menubar: true,
    plugins: 'lists link image table code media',
    toolbar: 'undo redo | styles | bold italic underline | alignleft aligncenter alignright alignjustify | bullist numlist outdent indent | link image media table | code | customImage customVideo',
    setup: function(editor) {
      editor.ui.registry.addButton('customImage', {
        text: '',
        icon: 'image',
        tooltip: 'Upload & Insert Image',
        onAction: function() {
          openCustomImageModal(editor);
        }
      });
      editor.ui.registry.addButton('customVideo', {
        text: '',
        icon: 'media',
        tooltip: 'Upload & Insert Video',
        onAction: function() {
          openCustomVideoModal(editor);
        }
      });
    }
  });

  function openCustomImageModal(editor) {
    var modal = document.createElement('div');
    modal.style.position = 'fixed';
    modal.style.top = '0';
    modal.style.left = '0';
    modal.style.width = '100vw';
    modal.style.height = '100vh';
    modal.style.background = 'rgba(0,0,0,0.5)';
    modal.style.display = 'flex';
    modal.style.alignItems = 'center';
    modal.style.justifyContent = 'center';
    modal.style.zIndex = '9999';
    modal.innerHTML = `
      <div style="background:#fff;padding:24px;border-radius:8px;min-width:320px;max-width:90vw;text-align:center;">
        <h5>Upload & Preview Image</h5>
        <input type="file" id="customImageInput" accept="image/*" style="margin-bottom:12px;" />
        <div id="customImagePreview" style="margin-bottom:12px;"></div>
        <button id="customImageInsert" class="btn btn-primary" disabled>Insert</button>
        <button id="customImageCancel" class="btn btn-secondary" style="margin-left:8px;">Cancel</button>
      </div>
    `;
    document.body.appendChild(modal);

    var input = modal.querySelector('#customImageInput');
    var preview = modal.querySelector('#customImagePreview');
    var insertBtn = modal.querySelector('#customImageInsert');
    var cancelBtn = modal.querySelector('#customImageCancel');
    var imageData = '';

    input.addEventListener('change', function() {
      var file = this.files[0];
      if (file) {
        var reader = new FileReader();
        reader.onload = function(e) {
          imageData = e.target.result;
          preview.innerHTML = `<img src="${imageData}" style="max-width:200px;max-height:200px;" />`;
          insertBtn.disabled = false;
        };
        reader.readAsDataURL(file);
      }
    });

    insertBtn.addEventListener('click', function() {
      if (imageData) {
        editor.insertContent(`<img src='${imageData}' style='max-width:100%;height:auto;' />`);
        document.body.removeChild(modal);
      }
    });
    cancelBtn.addEventListener('click', function() {
      document.body.removeChild(modal);
    });
  }

  function openCustomVideoModal(editor) {
    var modal = document.createElement('div');
    modal.style.position = 'fixed';
    modal.style.top = '0';
    modal.style.left = '0';
    modal.style.width = '100vw';
    modal.style.height = '100vh';
    modal.style.background = 'rgba(0,0,0,0.5)';
    modal.style.display = 'flex';
    modal.style.alignItems = 'center';
    modal.style.justifyContent = 'center';
    modal.style.zIndex = '9999';
    modal.innerHTML = `
      <div style="background:#fff;padding:24px;border-radius:8px;min-width:320px;max-width:90vw;text-align:center;">
        <h5>Upload & Preview Video</h5>
        <input type="file" id="customVideoInput" accept="video/mp4,video/webm,video/ogg" style="margin-bottom:12px;" />
        <div id="customVideoPreview" style="margin-bottom:12px;"></div>
        <button id="customVideoInsert" class="btn btn-primary" disabled>Insert</button>
        <button id="customVideoCancel" class="btn btn-secondary" style="margin-left:8px;">Cancel</button>
      </div>
    `;
    document.body.appendChild(modal);

    var input = modal.querySelector('#customVideoInput');
    var preview = modal.querySelector('#customVideoPreview');
    var insertBtn = modal.querySelector('#customVideoInsert');
    var cancelBtn = modal.querySelector('#customVideoCancel');
    var videoData = '';

    input.addEventListener('change', function() {
      var file = this.files[0];
      if (file) {
        var reader = new FileReader();
        reader.onload = function(e) {
          videoData = e.target.result;
          preview.innerHTML = `<video src="${videoData}" controls style="max-width:300px;max-height:200px;"></video>`;
          insertBtn.disabled = false;
        };
        reader.readAsDataURL(file);
      }
    });

    insertBtn.addEventListener('click', function() {
      if (videoData) {
        editor.insertContent(`<video src='${videoData}' controls style='max-width:100%;height:auto;'></video>`);
        document.body.removeChild(modal);
      }
    });
    cancelBtn.addEventListener('click', function() {
      document.body.removeChild(modal);
    });
  }
</script> 