<?php

use Illuminate\Support\Facades\Route;
use App\Http\Controllers\GoogleAuthController;
use App\Http\Controllers\MenuController;
use App\Http\Controllers\CKEditorController;
use App\Http\Controllers\HomeController;
use App\Http\Controllers\ProfileController;

Route::get('/', [HomeController::class, 'index']);

require __DIR__.'/auth.php';

Route::get('auth/google', [GoogleAuthController::class, 'redirectToGoogle']);
Route::get('auth/google/callback', [GoogleAuthController::class, 'handleGoogleCallback']);

Route::get('/home', [HomeController::class, 'index'])->name('home');

Route::get('/register', function () {
    return view('auth.register');
})->name('register.form');

Route::get('/profile', function () {
    return view('profile.profile');
})->middleware('auth')->name('profile');

Route::get('/profile/edit', [ProfileController::class, 'edit'])->middleware('auth')->name('profile.edit');

Route::post('/profile/edit', [App\Http\Controllers\ProfileController::class, 'update'])->middleware('auth')->name('profile.update');

Route::get('/login', function () {
    return view('auth.login');
})->name('login.form');

Route::get('/dashboard', [App\Http\Controllers\DashboardController::class, 'index'])->middleware('auth')->name('dashboard');

// Content routes
Route::resource('content', App\Http\Controllers\ContentController::class)->middleware('auth');
// Route download template HARUS SEBELUM resource menus!
Route::get('/menus/download-template', [MenuController::class, 'downloadTemplate'])->name('menus.downloadTemplate');

Route::resource('menus', MenuController::class);

// Route test untuk troubleshooting
Route::get('/test-route', function() { return 'OK'; });

// Route untuk menampilkan konten berdasarkan menu
Route::get('/menu/{menu}/contents', [MenuController::class, 'showContents'])->name('menu.contents');

Route::resource('contoh', App\Http\Controllers\ContohController::class)
    ->only(['create', 'store', 'edit', 'update', 'show', 'destroy'])
    ->middleware('auth');

// Tambahkan route index untuk contoh
Route::get('/contoh', [App\Http\Controllers\ContohController::class, 'index'])->name('contoh.index')->middleware('auth');

Route::resource('refleksi', App\Http\Controllers\RefleksiController::class)
    ->only(['create', 'store', 'edit', 'update', 'show', 'destroy'])
    ->middleware('auth');

Route::post('ckeditor/upload', [CKEditorController::class, 'upload'])->name('ckeditor.upload');

Route::post('/menus/import', [MenuController::class, 'import'])->name('import.menus');

Route::post('/categories', [App\Http\Controllers\CategoryController::class, 'store'])->name('categories.store');

// Tambahkan route untuk hapus semua konten dalam kategori tertentu
Route::delete('/category/{category}/delete-contents', [App\Http\Controllers\CategoryController::class, 'deleteContents'])->middleware('auth')->name('category.deleteContents');

Route::resource('feedback', App\Http\Controllers\FeedbackController::class)->only(['create', 'store', 'edit', 'update', 'show'])->middleware('auth');
