<!DOCTYPE html>
<html lang="en">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>Buat Konten Baru</title>
    <link href="https://cdn.jsdelivr.net/npm/bootstrap@5.3.0/dist/css/bootstrap.min.css" rel="stylesheet">
    <style>
    .tox-dialog__body .tox-form__group:has([name="width"]),
    .tox-dialog__body .tox-form__group:has([name="height"]),
    .tox-dialog__body .tox-form__group:has([name="caption"]),
    .tox-dialog__body .tox-form__group:has([name="alt"]),
    .tox-dialog__body .tox-form__group:has([name="src"]) {
      display: none !important;
    }
    </style>
</head>
<body>
<div class="container-fluid px-2 px-md-4 py-4">
    <div class="row justify-content-center">
        <div class="col-12 col-md-10 col-lg-8 mx-auto">
            <div class="card shadow-sm" style="border-radius: 1rem;">
                <div class="card-header">
                    <h4>Buat Konten Baru</h4>
                </div>
                <div class="card-body">
                    <form method="POST" action="<?php echo e(route('content.store')); ?>" enctype="multipart/form-data">
                        <?php echo csrf_field(); ?>
                        
                        <?php if(isset($selectedMenuId) && $selectedMenuId): ?>
                            <input type="hidden" name="title" value="<?php echo e(isset($menus) ? optional($menus->where('id', $selectedMenuId)->first())->name : ''); ?>">
                            <input type="hidden" name="description" value="<?php echo e(isset($menus) ? optional($menus->where('id', $selectedMenuId)->first())->description : ''); ?>">
                            <input type="hidden" name="menu_id" value="<?php echo e($selectedMenuId); ?>">
                        <?php else: ?>
                            <div class="mb-3">
                                <label for="title" class="form-label">Judul</label>
                                <input type="text" class="form-control <?php $__errorArgs = ['title'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?> is-invalid <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>" 
                                       id="title" name="title" value="<?php echo e(old('title')); ?>" required>
                                <?php $__errorArgs = ['title'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?>
                                    <div class="invalid-feedback"><?php echo e($message); ?></div>
                                <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>
                            </div>
                            <div class="mb-3">
                                <label for="description" class="form-label">Deskripsi</label>
                                <textarea class="form-control <?php $__errorArgs = ['description'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?> is-invalid <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>" 
                                          id="description" name="description" rows="4" required><?php echo e(old('description')); ?></textarea>
                                <?php $__errorArgs = ['description'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?>
                                    <div class="invalid-feedback"><?php echo e($message); ?></div>
                                <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>
                            </div>
                            <div class="mb-3">
                                <label for="menu_id" class="form-label">Menu</label>
                                <select class="form-control <?php $__errorArgs = ['menu_id'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?> is-invalid <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>" 
                                        id="menu_id" name="menu_id" required>
                                    <option value="">Pilih Menu</option>
                                    <?php $__currentLoopData = $menus; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $menu): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                        <option value="<?php echo e($menu->id); ?>" <?php echo e((old('menu_id') == $menu->id) ? 'selected' : ''); ?>>
                                            <?php echo e($menu->name); ?>

                                        </option>
                                    <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                                </select>
                                <?php $__errorArgs = ['menu_id'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?>
                                    <div class="invalid-feedback"><?php echo e($message); ?></div>
                                <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>
                            </div>
                        <?php endif; ?>

                        <div class="mb-3">
                            <label for="category_id" class="form-label">Kategori</label>
                            <div class="input-group">
                                <select class="form-control <?php $__errorArgs = ['category_id'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?> is-invalid <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>" 
                                        id="category_id" name="category_id">
                                    <option value="">Pilih Kategori (Opsional)</option>
                                    <?php $__currentLoopData = $categories; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $category): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                        <option value="<?php echo e($category->id); ?>" <?php echo e(old('category_id') == $category->id ? 'selected' : ''); ?>>
                                            <?php echo e($category->name); ?>

                                        </option>
                                    <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                                </select>
                                <button type="button" class="btn btn-outline-primary" id="addCategoryBtn" style="margin-left:8px;">Tambah Kategori</button>
                            </div>
                            <?php $__errorArgs = ['category_id'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?>
                                <div class="invalid-feedback"><?php echo e($message); ?></div>
                            <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>
                        </div>

                        <!-- Modal Tambah Kategori -->
                        <div class="modal fade" id="addCategoryModal" tabindex="-1" aria-labelledby="addCategoryModalLabel" aria-hidden="true">
                          <div class="modal-dialog">
                            <div class="modal-content">
                              <div class="modal-header">
                                <h5 class="modal-title" id="addCategoryModalLabel">Tambah Kategori Baru</h5>
                                <button type="button" class="btn-close" data-bs-dismiss="modal" aria-label="Close"></button>
                              </div>
                              <div class="modal-body">
                                <div class="mb-3">
                                  <label for="newCategoryName" class="form-label">Nama Kategori</label>
                                  <input type="text" class="form-control" id="newCategoryName" />
                                  <div class="invalid-feedback" id="newCategoryError"></div>
                                </div>
                              </div>
                              <div class="modal-footer">
                                <button type="button" class="btn btn-secondary" data-bs-dismiss="modal">Batal</button>
                                <button type="button" class="btn btn-primary" id="saveCategoryBtn">Simpan</button>
                              </div>
                            </div>
                          </div>
                        </div>

                        <div class="mb-3">
                            <label for="content" class="form-label">Konten</label>
                            <textarea class="form-control <?php $__errorArgs = ['content'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?> is-invalid <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>" 
                                      id="content" name="content" rows="8" style="height: 600px;"><?php echo e(old('content')); ?></textarea>
                            <?php $__errorArgs = ['content'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?>
                                <div class="invalid-feedback"><?php echo e($message); ?></div>
                            <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>
                        </div>

                        <div class="mb-3">
                            <label for="image" class="form-label">Gambar</label>
                            <input type="file" class="form-control <?php $__errorArgs = ['image'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?> is-invalid <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>" 
                                   id="image" name="image" accept="image/*">
                            <?php $__errorArgs = ['image'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?>
                                <div class="invalid-feedback"><?php echo e($message); ?></div>
                            <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>
                        </div>

                        <div class="mb-3">
                            <label for="status" class="form-label">Status</label>
                            <select class="form-control <?php $__errorArgs = ['status'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?> is-invalid <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>" 
                                    id="status" name="status" required>
                                <option value="">Pilih Status</option>
                                <option value="draft" <?php echo e(old('status') == 'draft' ? 'selected' : ''); ?>>Draft</option>
                                <option value="published" <?php echo e(old('status') == 'published' ? 'selected' : ''); ?>>Published</option>
                            </select>
                            <?php $__errorArgs = ['status'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?>
                                <div class="invalid-feedback"><?php echo e($message); ?></div>
                            <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>
                        </div>

                        <div class="d-flex justify-content-between">
                            <a href="<?php echo e($selectedMenuId ? route('menus.show', $selectedMenuId) : route('content.index')); ?>" class="btn btn-secondary">Kembali</a>
                            <button type="submit" class="btn btn-primary">Simpan Konten</button>
                        </div>
                    </form>
                </div>
            </div>
        </div>
    </div>
</div>
<script src="https://cdn.jsdelivr.net/npm/tinymce@6.8.3/tinymce.min.js"></script>
<script src="https://cdn.jsdelivr.net/npm/bootstrap@5.3.0/dist/js/bootstrap.bundle.min.js"></script>
<script>
  tinymce.init({
    selector: '#content',
    height: 600,
    menubar: true,
    plugins: 'lists link image table code media',
    toolbar: 'undo redo | styles | bold italic underline | alignleft aligncenter alignright alignjustify | bullist numlist outdent indent | link image media table | code | customImage customVideo',
    setup: function(editor) {
      editor.ui.registry.addButton('customImage', {
        text: '',
        icon: 'image',
        tooltip: 'Upload & Insert Image',
        onAction: function() {
          openCustomImageModal(editor);
        }
      });
      editor.ui.registry.addButton('customVideo', {
        text: '',
        icon: 'media',
        tooltip: 'Upload & Insert Video',
        onAction: function() {
          openCustomVideoModal(editor);
        }
      });
    }
  });

  function openCustomImageModal(editor) {
    // Create modal
    var modal = document.createElement('div');
    modal.style.position = 'fixed';
    modal.style.top = '0';
    modal.style.left = '0';
    modal.style.width = '100vw';
    modal.style.height = '100vh';
    modal.style.background = 'rgba(0,0,0,0.5)';
    modal.style.display = 'flex';
    modal.style.alignItems = 'center';
    modal.style.justifyContent = 'center';
    modal.style.zIndex = '9999';
    modal.innerHTML = `
      <div style="background:#fff;padding:24px;border-radius:8px;min-width:320px;max-width:90vw;text-align:center;">
        <h5>Upload & Preview Image</h5>
        <input type="file" id="customImageInput" accept="image/*" style="margin-bottom:12px;" />
        <div id="customImagePreview" style="margin-bottom:12px;"></div>
        <button id="customImageInsert" class="btn btn-primary" disabled>Insert</button>
        <button id="customImageCancel" class="btn btn-secondary" style="margin-left:8px;">Cancel</button>
      </div>
    `;
    document.body.appendChild(modal);

    var input = modal.querySelector('#customImageInput');
    var preview = modal.querySelector('#customImagePreview');
    var insertBtn = modal.querySelector('#customImageInsert');
    var cancelBtn = modal.querySelector('#customImageCancel');
    var imageData = '';

    input.addEventListener('change', function() {
      var file = this.files[0];
      if (file) {
        var reader = new FileReader();
        reader.onload = function(e) {
          imageData = e.target.result;
          preview.innerHTML = `<img src="${imageData}" style="max-width:200px;max-height:200px;" />`;
          insertBtn.disabled = false;
        };
        reader.readAsDataURL(file);
      }
    });

    insertBtn.addEventListener('click', function() {
      if (imageData) {
        editor.insertContent(`<img src='${imageData}' style='max-width:100%;height:auto;' />`);
        document.body.removeChild(modal);
      }
    });
    cancelBtn.addEventListener('click', function() {
      document.body.removeChild(modal);
    });
  }

  function openCustomVideoModal(editor) {
    var modal = document.createElement('div');
    modal.style.position = 'fixed';
    modal.style.top = '0';
    modal.style.left = '0';
    modal.style.width = '100vw';
    modal.style.height = '100vh';
    modal.style.background = 'rgba(0,0,0,0.5)';
    modal.style.display = 'flex';
    modal.style.alignItems = 'center';
    modal.style.justifyContent = 'center';
    modal.style.zIndex = '9999';
    modal.innerHTML = `
      <div style="background:#fff;padding:24px;border-radius:8px;min-width:320px;max-width:90vw;text-align:center;">
        <h5>Upload & Preview Video</h5>
        <input type="file" id="customVideoInput" accept="video/mp4,video/webm,video/ogg" style="margin-bottom:12px;" />
        <div id="customVideoPreview" style="margin-bottom:12px;"></div>
        <button id="customVideoInsert" class="btn btn-primary" disabled>Insert</button>
        <button id="customVideoCancel" class="btn btn-secondary" style="margin-left:8px;">Cancel</button>
      </div>
    `;
    document.body.appendChild(modal);

    var input = modal.querySelector('#customVideoInput');
    var preview = modal.querySelector('#customVideoPreview');
    var insertBtn = modal.querySelector('#customVideoInsert');
    var cancelBtn = modal.querySelector('#customVideoCancel');
    var videoData = '';

    input.addEventListener('change', function() {
      var file = this.files[0];
      if (file) {
        var reader = new FileReader();
        reader.onload = function(e) {
          videoData = e.target.result;
          preview.innerHTML = `<video src="${videoData}" controls style="max-width:300px;max-height:200px;"></video>`;
          insertBtn.disabled = false;
        };
        reader.readAsDataURL(file);
      }
    });

    insertBtn.addEventListener('click', function() {
      if (videoData) {
        editor.insertContent(`<video src='${videoData}' controls style='max-width:100%;height:auto;'></video>`);
        document.body.removeChild(modal);
      }
    });
    cancelBtn.addEventListener('click', function() {
      document.body.removeChild(modal);
    });
  }

  // Tambah Kategori
  document.addEventListener('DOMContentLoaded', function() {
    var addCategoryBtn = document.getElementById('addCategoryBtn');
    var addCategoryModal = new bootstrap.Modal(document.getElementById('addCategoryModal'));
    var saveCategoryBtn = document.getElementById('saveCategoryBtn');
    var newCategoryName = document.getElementById('newCategoryName');
    var newCategoryError = document.getElementById('newCategoryError');
    var categorySelect = document.getElementById('category_id');

    addCategoryBtn.addEventListener('click', function() {
      newCategoryName.value = '';
      newCategoryError.textContent = '';
      newCategoryName.classList.remove('is-invalid');
      addCategoryModal.show();
    });

    saveCategoryBtn.addEventListener('click', function() {
      var name = newCategoryName.value.trim();
      if (!name) {
        newCategoryError.textContent = 'Nama kategori wajib diisi';
        newCategoryName.classList.add('is-invalid');
        return;
      }
      newCategoryError.textContent = '';
      newCategoryName.classList.remove('is-invalid');
      saveCategoryBtn.disabled = true;
      saveCategoryBtn.textContent = 'Menyimpan...';
      fetch('/categories', {
        method: 'POST',
        headers: {
          'Content-Type': 'application/json',
          'X-CSRF-TOKEN': document.querySelector('input[name="_token"]').value
        },
        body: JSON.stringify({ name: name })
      })
      .then(response => response.json())
      .then(data => {
        saveCategoryBtn.disabled = false;
        saveCategoryBtn.textContent = 'Simpan';
        if (data.success && data.category) {
          // Tambahkan ke select
          var option = document.createElement('option');
          option.value = data.category.id;
          option.textContent = data.category.name;
          option.selected = true;
          categorySelect.appendChild(option);
          addCategoryModal.hide();
        } else {
          newCategoryError.textContent = data.message || 'Gagal menambah kategori';
          newCategoryName.classList.add('is-invalid');
        }
      })
      .catch(() => {
        saveCategoryBtn.disabled = false;
        saveCategoryBtn.textContent = 'Simpan';
        newCategoryError.textContent = 'Terjadi kesalahan.';
        newCategoryName.classList.add('is-invalid');
      });
    });
  });
</script>
</body>
</html> <?php /**PATH /home/rama3823/public_html/tisel/resources/views/content/create.blade.php ENDPATH**/ ?>