

<?php $__env->startSection('content'); ?>
<div class="container-fluid px-2 px-md-4 py-4">
    <div class="row justify-content-center">
        <div class="col-12">
            <div class="card shadow-sm" style="border-radius: 1rem;">
                <div class="card-header d-flex justify-content-between align-items-center">
                    <h4 class="mb-0">Daftar Konten</h4>
                    <a href="<?php echo e(route('content.create')); ?>" class="btn btn-primary">+ Tambah Konten</a>
                </div>
                <div class="card-body">
                    <?php if(session('success')): ?>
                        <div class="alert alert-success"><?php echo e(session('success')); ?></div>
                    <?php endif; ?>
                    <div class="table-responsive">
                        <table class="table table-bordered table-hover align-middle">
                            <thead class="table-light">
                                <tr>
                                    <th style="width: 5%">No</th>
                                    <th>Judul</th>
                                    <th>Menu</th>
                                    <th>Kategori</th>
                                    <th>Status</th>
                                    <th>Penulis</th>
                                    <th>Tanggal Dibuat</th>
                                    <th style="width: 15%">Aksi</th>
                                </tr>
                            </thead>
                            <tbody>
                                <?php $__empty_1 = true; $__currentLoopData = $contents; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $index => $content): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); $__empty_1 = false; ?>
                                    <tr>
                                        <td><?php echo e($index + 1); ?></td>
                                        <td><?php echo e($content->title); ?></td>
                                        <td><?php echo e($content->menu->name ?? '-'); ?></td>
                                        <td><?php echo e($content->category->name ?? '-'); ?></td>
                                        <td>
                                            <span class="badge bg-<?php echo e($content->status == 'published' ? 'success' : 'warning'); ?>">
                                                <?php echo e(ucfirst($content->status)); ?>

                                            </span>
                                        </td>
                                        <td><?php echo e($content->user->name ?? '-'); ?></td>
                                        <td><?php echo e($content->created_at ? $content->created_at->format('d M Y H:i') : '-'); ?></td>
                                        <td>
                                            <a href="<?php echo e(route('content.show', $content->id)); ?>" class="btn btn-info btn-sm" title="Lihat"><i class="fas fa-eye"></i></a>
                                            <a href="<?php echo e(route('content.edit', $content->id)); ?>" class="btn btn-warning btn-sm" title="Edit"><i class="fas fa-edit"></i></a>
                                            <form action="<?php echo e(route('content.destroy', $content->id)); ?>" method="POST" style="display:inline;">
                                                <?php echo csrf_field(); ?>
                                                <?php echo method_field('DELETE'); ?>
                                                <button type="submit" class="btn btn-danger btn-sm" onclick="return confirm('Yakin ingin menghapus konten ini?')" title="Hapus"><i class="fas fa-trash"></i></button>
                                            </form>
                                        </td>
                                    </tr>
                                <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); if ($__empty_1): ?>
                                    <tr>
                                        <td colspan="8" class="text-center text-muted">Belum ada data konten.</td>
                                    </tr>
                                <?php endif; ?>
                            </tbody>
                        </table>
                    </div>
                    <div class="d-flex justify-content-center mt-3">
                        
                    </div>
                </div>
            </div>
        </div>
    </div>
</div>
<?php $__env->stopSection(); ?>

<?php echo $__env->make('layouts.dashboard', array_diff_key(get_defined_vars(), ['__data' => 1, '__path' => 1]))->render(); ?><?php /**PATH /home/rama3823/public_html/tisel/resources/views/content/index.blade.php ENDPATH**/ ?>